<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is PUT (to indicate update)
if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve the `wishlist_id` from the URL
$wishlist_id = $_GET['wishlist_id'] ?? null;

if (!$wishlist_id) {
    echo json_encode(["status" => "error", "message" => "Wishlist ID is required"]);
    exit;
}

// Sanitize `wishlist_id` to prevent SQL injection
$wishlist_id = intval($wishlist_id);

// Get the current date for `removed_date`
$current_date = date('Y-m-d H:i:s');

// Query to update the `removed_date` and mark the item as removed (set `delete_status` to 1)
$query = "UPDATE wish_list 
          SET removed_date = '$current_date', delete_status = 1 
          WHERE wishlist_id = $wishlist_id";

// Execute the query
if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "Wishlist item removed successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to remove wishlist item"]);
}
?>
